/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $ */

'use strict';

require.config({
    // 3rd party script alias names (Easier to type "jquery" than "libs/jquery, etc")
    // probably a good idea to keep version numbers in the file names for updates checking
    paths: {
        // Core Libraries
        "jquery": "test/libs/jquery/jquery-1.9.1",
        "jqueryui": "test/libs/jqueryui/jqueryui-1.9.2",
        "jquerymobile": "test/libs/jqm/jquery.mobile-1.3.1",
        "underscore": "test/libs/marionette/lodash-1.3.1",
        "backbone": "test/libs/marionette/backbone-1.0.0",
        "marionette": "test/libs/marionette/backbone.marionette-1.1.0",
        "handlebars": "test/libs/handlebars/handlebars-1.0.0",
        "hbs": "test/libs/handlebars/hbs-0.4.0",
        "i18nprecompile": "test/libs/handlebars/i18nprecompile",
        "json2": "test/libs/marionette/json2",
        "jasmine": "test/libs/jasmine/jasmine-1.3.1",
        "jasmine-html": "test/libs/jasmine/jasmine-html-1.3.1",

        // Plugins
        "text": "test/libs/require/plugins/text",
        "jasminejquery": "test/libs/jquery/plugins/jasmine-jquery",
        "jquery.form": "test/libs/jquery/plugins/jquery.form.min-20130616",

        "applets/wound-care-applet": ".",
        "Portal": "test/mock/Portal",
        "parser":'core/utilities/parser',

        // Test directory
        "test": "test",
        'applet-path':'applets/wound-care-applet'
    },
    // Sets the configuration for your third party scripts that are not AMD compatible
    shim: {
        // jQueryUI
        "jqueryui": ["jquery"],
        // jQuery mobile
        "jquerymobile": ["jqueryui"],
        // Backbone
        "backbone": {
            // Depends on underscore/lodash and jQuery
            "deps": ["underscore", "jquery"],
            // Exports the global window.Backbone object
            "exports": "Backbone"
        },
        //Marionette
        "marionette": {
            "deps": ["underscore", "backbone", "jquery"],
            "exports": "Marionette"
        },
        //Handlebars
        "handlebars": {
            "exports": "Handlebars"
        },

        "jasmine": {
          "deps": ["jasminejquery"],
            // Exports the global 'window.jasmine' object
            "exports": "jasmine"
        },

        "jasmine-html": {
            "deps": ["jasmine"],
            "exports": "jasmine"
        }
    },
    // hbs config - must duplicate in Gruntfile.js Require build
    hbs: {
        templateExtension: "html",
        disableI18n: true,
        disableHelpers: true,
        //helperDirectory: "templates/helpers/",
        //i18nDirectory: "templates/i18n/",

        compileOptions: {}        // options object which is passed to Handlebars compiler
    }
});
